﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using DataAccess;

/// <summary>
/// Methods and properties used to load and save ethnicity/race data
/// </summary>
public class CPatEthnicityRace
{
    /// <summary>
    /// Default constructor
    /// </summary>
	public CPatEthnicityRace()
	{
	}

    /// <summary>
    /// Insert patient ethnicity
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <param name="lEthnicityID"></param>
    /// <returns></returns>
    public bool InsertPatientEthnicity(
        BaseMaster BaseMstr,
        string strPatientID,
        long lEthnicityID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = string.Empty;

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vPatientID", strPatientID);
        plist.AddInputParameter("pi_nEthnicityID", lEthnicityID);

        BaseMstr.DBConn.ExecuteOracleSP(
            "PCK_PAT_ETHNICITY_RACE.InsertPatientEthnicity",
            plist,
            out lStatusCode,
            out strStatusComment);

        //set the base mastekr status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;

        // 0 = success if strStatus is populated it will show on the screen
        // 1 to n are errors and we always show errors
        if (lStatusCode == 0)
        {
            return true;
        }

        return false;
    }

    /// <summary>
    /// Insert patient race
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <param name="lRaceID"></param>
    /// <returns></returns>
    public bool InsertPatientRace(
        BaseMaster BaseMstr,
        string strPatientID,
        long lRaceID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = string.Empty;

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID, BaseMstr.ClientIP, BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vPatientID", strPatientID);
        plist.AddInputParameter("pi_nRaceID", lRaceID);

        BaseMstr.DBConn.ExecuteOracleSP(
            "PCK_PAT_ETHNICITY_RACE.InsertPatientRace",
            plist,
            out lStatusCode,
            out strStatusComment);

        //set the base mastekr status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;

        // 0 = success if strStatus is populated it will show on the screen
        // 1 to n are errors and we always show errors
        if (lStatusCode == 0)
        {
            return true;
        }

        return false;
    }

    /// <summary>
    /// Insert patient ethniocity race source
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <param name="lSourceID"></param>
    /// <returns></returns>
    public bool InsertPatEthRaceSource(
        BaseMaster BaseMstr,
        string strPatientID,
        long lSourceID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = string.Empty;

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID, BaseMstr.ClientIP, BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vPatientID", strPatientID);
        plist.AddInputParameter("pi_nSourceID", lSourceID);

        BaseMstr.DBConn.ExecuteOracleSP(
            "PCK_PAT_ETHNICITY_RACE.InsertPatEthRaceSource",
            plist,
            out lStatusCode,
            out strStatusComment);

        //set the base mastekr status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;

        // 0 = success if strStatus is populated it will show on the screen
        // 1 to n are errors and we always show errors
        if (lStatusCode == 0)
        {
            return true;
        }

        return false;
    }

    /// <summary>
    /// Get ethnicity dataset
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <returns></returns>
    public DataSet GetEthnicityDS(BaseMaster BaseMstr)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = string.Empty;

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID, BaseMstr.ClientIP, BaseMstr.FXUserID);

        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(
            BaseMstr.DBConn,
            "PCK_PAT_ETHNICITY_RACE.GetEthnicityRS",
            plist,
            out lStatusCode,
            out strStatusComment);

        //set the base master status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// Get race dataset
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <returns></returns>
    public DataSet GetRaceDS(BaseMaster BaseMstr)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = string.Empty;

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID, BaseMstr.ClientIP, BaseMstr.FXUserID);

        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(
            BaseMstr.DBConn,
            "PCK_PAT_ETHNICITY_RACE.GetRaceRS",
            plist,
            out lStatusCode,
            out strStatusComment);

        //set the base master status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// Get ethnicity race source dataset
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <returns></returns>
    public DataSet GetEthRaceSourceDS(BaseMaster BaseMstr)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = string.Empty;

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID, BaseMstr.ClientIP, BaseMstr.FXUserID);

        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(
            BaseMstr.DBConn,
            "PCK_PAT_ETHNICITY_RACE.GetEthRaceSourceRS",
            plist,
            out lStatusCode,
            out strStatusComment);

        //set the base master status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// Get patient ethnicty dataset
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public DataSet GetPatientEthnicityDS(
        BaseMaster BaseMstr,
        string strPatientID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = string.Empty;

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID, BaseMstr.ClientIP, BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vPatientID", strPatientID);

        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(
            BaseMstr.DBConn,
            "PCK_PAT_ETHNICITY_RACE.GetPatientEthnicityRS",
            plist,
            out lStatusCode,
            out strStatusComment);

        //set the base master status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// Get patient race dataset
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public DataSet GetPatientRaceDS(
        BaseMaster BaseMstr,
        string strPatientID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = string.Empty;

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID, BaseMstr.ClientIP, BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vPatientID", strPatientID);

        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(
            BaseMstr.DBConn,
            "PCK_PAT_ETHNICITY_RACE.GetPatientRaceRS",
            plist,
            out lStatusCode,
            out strStatusComment);

        //set the base master status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// Get patient ethnicity race source dataset
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public DataSet GetPatEthRaceSourceDS(
        BaseMaster BaseMstr,
        string strPatientID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = string.Empty;

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID, BaseMstr.ClientIP, BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vPatientID", strPatientID);

        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(
            BaseMstr.DBConn,
            "PCK_PAT_ETHNICITY_RACE.GetPatEthRaceSourceRS",
            plist,
            out lStatusCode,
            out strStatusComment);

        //set the base master status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// Delete patient ethnicity
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public bool DeletePatientEthnicity(
        BaseMaster BaseMstr,
        string strPatientID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = string.Empty;

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID, BaseMstr.ClientIP, BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vPatientID", strPatientID);

        BaseMstr.DBConn.ExecuteOracleSP(
            "PCK_PAT_ETHNICITY_RACE.DeletePatientEthnicity",
            plist,
            out lStatusCode,
            out strStatusComment);

        //set the base mastekr status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;

        // 0 = success if strStatus is populated it will show on the screen
        // 1 to n are errors and we always show errors
        if (lStatusCode == 0)
        {
            return true;
        }

        return false;
    }

    /// <summary>
    /// Delete patient race
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public bool DeletePatientRace(
        BaseMaster BaseMstr,
        string strPatientID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = string.Empty;

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID, BaseMstr.ClientIP, BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vPatientID", strPatientID);

        BaseMstr.DBConn.ExecuteOracleSP(
            "PCK_PAT_ETHNICITY_RACE.DeletePatientRace",
            plist,
            out lStatusCode,
            out strStatusComment);

        //set the base mastekr status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;

        // 0 = success if strStatus is populated it will show on the screen
        // 1 to n are errors and we always show errors
        if (lStatusCode == 0)
        {
            return true;
        }

        return false;
    }

    /// <summary>
    /// Delete patient ethnicity race source
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public bool DeletePatEthRaceSource(
        BaseMaster BaseMstr,
        string strPatientID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = string.Empty;

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID, BaseMstr.ClientIP, BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vPatientID", strPatientID);

        BaseMstr.DBConn.ExecuteOracleSP(
            "PCK_PAT_ETHNICITY_RACE.DeletePatEthRaceSource",
            plist,
            out lStatusCode,
            out strStatusComment);

        //set the base mastekr status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;

        // 0 = success if strStatus is populated it will show on the screen
        // 1 to n are errors and we always show errors
        if (lStatusCode == 0)
        {
            return true;
        }

        return false;
    }
}
